% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_volume.R
\name{vol.overlay.colors.from.activation}
\alias{vol.overlay.colors.from.activation}
\title{Generate colors for a 3D volume, based on the activation data and a colormap.}
\usage{
vol.overlay.colors.from.activation(
  volume,
  colormap_fn = squash::blueorange,
  no_act_source_value = 0
)
}
\arguments{
\item{volume}{a 3D array, the activation data (or p-values, effect sizes, or whatever)}

\item{colormap_fn}{function, a colormap function}

\item{no_act_source_value}{numerical scalar, the value from the data in 'volume' that means no activation. The output colors for this value will be set to `NA`.}
}
\value{
a 3D matrix of color strings, with the same dimensions as the input volume
}
\description{
Applies the colormap function to the data, then sets the alpha value (transparency) to full in all areas without any activation. Feel free to clip data or whatever before passing it, so that all your no-activation data has the same value.
}
\seealso{
Other volume utility: 
\code{\link{vol.boundary.box}()},
\code{\link{vol.imagestack}()},
\code{\link{vol.merge}()},
\code{\link{vol.planes}()},
\code{\link{vol.slice}()}
}
\concept{volume utility}
