% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_group.R
\name{vis.group.annot}
\alias{vis.group.annot}
\title{Plot atlas annotations for a group of subjects.}
\usage{
vis.group.annot(
  subjects_dir,
  subject_id,
  atlas,
  view_angles = "sd_dorsal",
  output_img = "fsbrain_group_annot.png",
  num_per_row = 5L,
  captions = subject_id,
  rglactions = list(no_vis = TRUE),
  ...
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{vector of character strings, the subject identifiers}

\item{atlas}{vector of character strings, the atlas names. Example: \code{c('aparc', 'aparc.a2009s')}}

\item{view_angles}{see \code{\link{get.view.angle.names}}.}

\item{output_img}{character string, the file path for the output image. Should end with '.png'.}

\item{num_per_row}{positive integer, the number of tiles per row.}

\item{captions}{optional vector of character strings, the short text annotations for the individual tiles. Typically used to plot the subject identifier.}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action. The following example clips outliers in the data before plotting and writes a screenshot in PNG format: \code{rglactions = list("snapshot_png"="~/fsbrain.png", "clip_data"=c(0.05, 0.95))}. See \code{\link{rglactions}}.}

\item{...}{extra parameters passed to the subject level visualization function. Not all may make sense in this context. Example: \code{surface='pial'}.}
}
\value{
named list, see the return value of \code{\link{arrange.brainview.images.grid}} for details.
}
\description{
Plot atlas annotations for a group of subjects and combine them into a single large image.
}
\note{
The subjects are plotted row-wise, in the order in which they appear in the 'subject_id' parameter. This function is vectorized over 'subject_id' and 'atlas'.
}
\seealso{
Other group visualization functions: 
\code{\link{vis.data.on.group.native}()},
\code{\link{vis.data.on.group.standard}()},
\code{\link{vis.group.coloredmeshes}()},
\code{\link{vis.group.morph.native}()},
\code{\link{vis.group.morph.standard}()}
}
\concept{group visualization functions}
