% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spherical.R
\name{sph2fs}
\alias{sph2fs}
\title{Transform spherical coordinates to FreeSurfer surface space to plot things around a brain.}
\usage{
sph2fs(
  lon,
  lat,
  radius = surf.radius.fsaverage(),
  center = surf.center.fsaverage(),
  deg = TRUE
)
}
\arguments{
\item{lon}{numerical vector, the longitudes, passed to \code{sphereplot::sph2car}. See 'deg' for unit information.}

\item{lat}{numerical vector, the latitudes, passed to \code{sphereplot::sph2car}. See 'deg' for unit information.}

\item{radius}{numerical vector, the radii, passed to \code{sphereplot::sph2car}. Defaults to the radius of the combined mesh from the fsaverage lh and rh surfaces.}

\item{center}{numerical vector of length 3, the x, y, and z coordinates of the target center. The \code{sphereplot::sph2car} function operates on the unit sphere, and this parameter is used to translate the resulting cartesian coordinates to a new center, typically the center of the surface meshes or MRI volume or substructures. If you want no translation, pass \code{c(0,0,0)}.}

\item{deg}{logical, whether to use degrees (as opposed to radians) as the unit for 'lat' and 'lon'. Passed to \code{sphereplot::sph2car}.}
}
\description{
Transform spherical coordinates to FreeSurfer surface space to plot things around a brain.
}
\note{
This function can be used to plot things in FreeSurfer space using spherical coordinates, as commonly used in EEG to define electrode positions. Requires the 'sphereplot' package.
}
\examples{
\dontrun{
    # Draw voxels on a sphere around fsaverage:
    lat = seq.int(from=0, to=360, by=30);
    lon = rep(0, length(lat));
    vis.fs.surface('~/software/freesurfer/subjects/fsaverage/surf/lh.white');
    fsbrain::rglvoxels(sph2fs(lat, lon), voxelcol = 'red');
    fsbrain::rglvoxels(sph2fs(lon, lat), voxelcol = 'green');
}

}
\keyword{internal}
