% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume.R
\name{ras2vox_tkr}
\alias{ras2vox_tkr}
\title{The FreeSurfer default ras2vox_tkr matrix.}
\usage{
ras2vox_tkr()
}
\value{
numeric 4x4 matrix, the FreeSurfer ras2vox_tkr matrix.
}
\description{
Applying this matrix to a FreeSurfer surface RAS coordinate (from a surface file like `lh.white`) will give you the voxel index (CRS) in a conformed FreeSurfer volume.  The returned matrix is the inverse of the `vox2ras_tkr` matrix.
}
\examples{
   # Compute the FreeSurfer CRS voxel index of surface RAS coordinate (0.0, 0.0, 0.0):
   ras2vox_tkr() \%*\% c(0, 0, 0, 1);
   # Show that the voxel at surface RAS corrds (0.0, 0.0, 0.0) is the one with CRS (128, 128, 128):
   ras2vox_tkr() \%*\% c(0.0, 0.0, 0.0, 1);

}
\seealso{
Other surface and volume coordinates: 
\code{\link{vox2ras_tkr}()}
}
\concept{surface and volume coordinates}
