% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_value.R
\name{format_value}
\alias{format_value}
\title{Converts a (possibly compound) value into a string using the \code{format} information}
\usage{
format_value(
  x,
  format = NULL,
  output = c("ascii", "html"),
  na_str = "NA",
  round_type = c("iec", "sas")
)
}
\arguments{
\item{x}{(\code{ANY})\cr the value to be formatted.}

\item{format}{(\code{string} or \code{function})\cr the format label (string) or formatter function to
apply to \code{x}.}

\item{output}{(\code{string})\cr output type.}

\item{na_str}{(\code{character})\cr character vector to display when the values of \code{x} are missing.
If only one string is provided, it is applied for all missing values. Defaults to \code{"NA"}.}

\item{round_type}{(\code{"iec"} or \code{"sas"})\cr the type of rounding to perform. iec,
the default, peforms rounding compliant with IEC 60559 (see details), while
sas performs nearest-value rounding consistent with rounding within SAS.}
}
\value{
Formatted text representing the cell \code{x}.
}
\description{
Converts a (possibly compound) value into a string using the \code{format} information
}
\details{
A length-zero value for \code{na_str} will be interpreted as \code{"NA"}.
}
\examples{
x <- format_value(pi, format = "xx.xx")
x

format_value(x, output = "ascii")

# na_str works with multiple values
format_value(c(NA, 1, NA), format = "xx.x (xx.x - xx.x)", na_str = c("NE", "<missing>"))

}
\seealso{
\code{\link[=round_fmt]{round_fmt()}}
}
