% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canopy-height.R
\name{fd_canopy_height_meta}
\alias{fd_canopy_height_meta}
\title{Forest Canopy Height}
\usage{
fd_canopy_height_meta(
  x = NULL,
  lon = NULL,
  lat = NULL,
  crop = FALSE,
  mask = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{a \code{sf} or \code{SpatVector} object. It will retrieve the
necessary tiles to cover the area (if \code{lat} and \code{lon} are
specified, this argument is ignored)}

\item{lon}{a number specifying the longitude of the area where we want the tile}

\item{lat}{a number specifying the latitude of the area where we want the tile}

\item{crop}{when \code{x} is specified, whether to crop the tile(s) to the object}

\item{mask}{when \code{x} is specified, whether to mask the tile(s) to the object}

\item{quiet}{if \code{TRUE}, suppress any message or progress bar}
}
\value{
A \code{SpatRaster}
}
\description{
Download the High Resolution 1m Global Canopy Height Map
}
\details{
Data may be freely used for research, study, or teaching, but be cited
appropriately (see references below).
}
\examples{
\donttest{
canopy_height <- fd_canopy_height_meta(lon = -7.27, lat = 42.43)
}
}
\references{
\url{https://registry.opendata.aws/dataforgood-fb-forests/}
}
\keyword{internal}
