% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityMetrics.R
\name{fmpc_security_tech_indic}
\alias{fmpc_security_tech_indic}
\title{Technical Indicators}
\usage{
fmpc_security_tech_indic(
  symbols = "AAPL",
  indicator = c("SMA", "EMA", "WMA", "DEMA", "TEMA", "williams", "RSI", "ADX",
    "standardDeviation"),
  freq = c("daily", "1min", "5min", "15min", "30min", "1hour", "4hour"),
  period = 10
)
}
\arguments{
\item{symbols}{one or more symbols from the FMP available list that can be
found using \code{\link{fmpc_symbols_by_market}}. A valid API token must be
set in order to enable functionality. See documentation for setting a token
under \code{\link{fmpc_set_token}}.}

\item{indicator}{'SMA', 'EMA', 'WMA', 'DEMA', 'TEMA', 'williams', 'RSI',
'ADX', 'standardDeviation'}

\item{freq}{the frequency of which to pull intraday data. Options are
'1min', '5min', '15min', '30min', '1hour'}

\item{period}{Number of periods over which to calculate the technical
indicator}
}
\value{
technical indicator in a data frame
}
\description{
Pull Technical Indicators for a set of symbols over a specific number of
periods set by the frequency
}
\details{
Technical indicators include: 'SMA', 'EMA', 'WMA', 'DEMA', 'TEMA',
'williams', 'RSI', 'ADX', 'standardDeviation'
}
\examples{

\dontrun{

# Setting API key to DEMO allows for AAPL only
fmpc_set_token()
fmpc_security_tech_indic('AAPL')
fmpc_security_tech_indic('AAPL', indicator = 'standardDeviation')
fmpc_security_tech_indic('AAPL', 'sma')

# For multiple symbols, set a valid API Token
fmpc_set_token('FMPAPIKEY')
fmpc_security_tech_indic(c('AAPL','MSFT','SPY'), indicator = 'RSI', freq = '15min', period = 25)

}
}
