% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-methods.R
\name{is_good}
\alias{is_good}
\title{Good date checker}
\usage{
is_good(dates, calendar)
}
\arguments{
\item{dates}{a vector of dates}

\item{calendar}{an object inheriting from either \link{Calendar} or
\link{JointCalendar}. Dispatch to methods occurs on this argument.}
}
\value{
a logical vector with \code{TRUE} if the date is good and \code{FALSE} if the
date is bad
}
\description{
Checks whether dates are business days (good days) in a given locale
represented by a \code{Calendar}.
}
\details{
An \code{is_good} method must be written for each calendar. The default method
returns \code{TRUE} for all dates. Methods have been implemented for each of the
calendars inheriting from the \code{Calendar} class - see the method's code for
more details. The method implemented for the \code{JointCalendar} class checks
whether the supplied dates are good in each or any of the locales represented
by the joint calendar depending on the rule specified by the joint calendar.
}
\examples{
is_good(lubridate::ymd(20160126, 20160411), AUSYCalendar())
is_good(lubridate::ymd(20160126), USNYCalendar())
}
\seealso{
Calendar

Other calendar methods: \code{\link{adjust}},
  \code{\link{generate_schedule}},
  \code{\link{is_valid_bdc}}, \code{\link{is}},
  \code{\link{locale}}, \code{\link{shift}},
  \code{\link{tz}}
}
