% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{b2greek}
\alias{b2greek}
\title{Find the Greek-Letter Parameterization corresponding to a b Vector of
Item Parameters}
\usage{
b2greek(bvec, eps = 1e-08)
}
\arguments{
\item{bvec}{b vector of item parameters (i.e., polynomial coefficients).}

\item{eps}{Convergence tolerance.}
}
\value{
A vector of item parameters in the Greek-letter parameterization.
}
\description{
Convert the b vector of item parameters (polynomial coefficients) to the
corresponding Greek-letter parameterization (used to ensure monotonicitiy).
}
\details{
See \link{greek2b} for more information about the b (polynomial
coefficient) and Greek-letter parameterizations of the FMP model.
}
\examples{

(bvec <- greek2b(xi = 0, omega = 1, alpha = c(.1, .1), tau = c(-2, -2)))
## 0.00000000  2.71828183 -0.54365637  0.29961860 -0.03950623  0.01148330

(b2greek(bvec))
##  0.0  1.0  0.1 -2.0  0.1 -2.0

}
\references{
Liang, L., & Browne, M. W. (2015). A quasi-parametric method for
fitting flexible item response functions. \emph{Journal of Educational and
Behavioral Statistics}, \emph{40}, 5--34. \doi{10.3102/1076998614556816}
}
\seealso{
\link{greek2b}
}
