% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{r2}
\alias{r2}
\title{R2s of \code{fixest} models}
\usage{
r2(x, type = "all")
}
\arguments{
\item{x}{A \code{fixest} object, e.g. obtained with function \code{\link[fixest]{feglm}} or \code{\link[fixest]{feols}}.}

\item{type}{A character vector representing the R2 to compute. The R2 codes are of the form: "wapr2" with letters "w" (within), "a" (adjusted) and "p" (pseudo) possibly missing. E.g. to get the regular R2: use \code{type = "r2"}, the within adjusted R2: use \code{type = "war2"}, the pseudo R2: use \code{type = "pr2"}, etc. Use \code{"sq.cor"} for the squared correlation. By default, all R2s are computed.}
}
\value{
Returns a named vector.
}
\description{
Reports different R2s for \code{fixest} estimations (e.g. \code{\link[fixest]{feglm}} or \code{\link[fixest]{feols}}).
}
\examples{

# Load trade data
data(trade)

# We estimate the effect of distance on trade (with 3 fixed-effects)
est_pois = femlm(Euros ~ log(dist_km)|Origin+Destination+Product, trade)

# Squared correlation:
r2(est_pois, "sq.cor")

# "regular" r2:
r2(est_pois, "r2")

# pseudo r2
r2(est_pois, "pr2")

# within adjusted r2
r2(est_pois, "war2")

# all four at once
r2(est_pois, c("sq.cor", "r2", "pr2", "war2"))

}
\author{
Laurent Berge
}
