% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_metadata.R
\name{indicator_metadata}
\alias{indicator_metadata}
\title{Indicator metadata}
\usage{
indicator_metadata(IndicatorID = NULL, DomainID = NULL, ProfileID = NULL,
  path)
}
\arguments{
\item{IndicatorID}{Numeric vector, id of the indicator of interest}

\item{DomainID}{Numeric vector, id of domains of interest}

\item{ProfileID}{Numeric vector, id of profiles of interest. Indicator
polarity can vary between profiles therefore if using one of the comparison
fields it is recommended to complete this field as well as IndicatorID. If
IndicatorID is populated, ProfileID can be ignored or must be the same
length as IndicatorID (but can contain NAs).}

\item{path}{String; Fingertips API address. Function will default to the
correct address}
}
\value{
The metadata associated with each indicator/domain/profile identified
}
\description{
Outputs a data frame containing the metadata for selected indicators. Note, this
function can take up to a few minutes to run (depending on internet
connection speeds)
}
\examples{
\dontrun{
# Returns metadata for indicator ID 90362 and 1107
indicatorIDs <- c(90362, 1107)
indicator_metadata(indicatorIDs)

# Returns metadata for the indicators within the domain 1000101
indicator_metadata(DomainID = 1000101)

# Returns metadata for the indicators within the profile with the ID 129
indicator_metadata(ProfileID = 129)}
}
\seealso{
\code{\link{indicators}} for indicator lookups,
  \code{\link{profiles}} for profile lookups,
  \code{\link{deprivation_decile}} for deprivation lookups,
  \code{\link{area_types}} for area types and their parent mappings,
  \code{\link{category_types}} for category lookups,
  \code{\link{indicator_areatypes}} for indicators by area types lookups,
  \code{\link{indicators_unique}} for unique indicatorids and their names,
  \code{\link{nearest_neighbours}} for a vector of nearest neighbours for an area and
  \code{\link{indicator_order}} for the order indicators are presented on the
  Fingertips website within a Domain

Other lookup functions: \code{\link{area_types}},
  \code{\link{category_types}},
  \code{\link{deprivation_decile}},
  \code{\link{indicator_areatypes}},
  \code{\link{indicator_order}},
  \code{\link{indicators_unique}},
  \code{\link{indicators}},
  \code{\link{nearest_neighbours}}, \code{\link{profiles}}
}
