\name{make.fdt.multiple}
\alias{make.fdt.multiple}

\title{
  A function which makes the table using the number of interval classes, 
  a method used for breaks, and choose the endpoint
}

\description{
  A function which makes the table by using parameters defining the number of
  interval classes, the method used for breaks, "Sturges", "Scott", "FD", 
  and the closure of the interval class endpoints being left or right.
}

\usage{
  make.fdt.multiple(x, k, breaks = c("Sturges", "Scott", "FD"), right)
}

\arguments{
  \item{x}{A \code{data.frame} or \code{matrix} object containing at last one
   numeric column.}
  \item{k}{Number of class intervals.}
  \item{breaks}{Method to determine number of classes, c("Sturges", "Scott",
    "FD").}
  \item{right}{Intervals right open (default = FALSE).}
}

\details{
  A function which makes the table by using parameters defining the number of
  interval classes, the method used for breaks, "Sturges", "Scott", "FD", 
  and the closure of the interval class endpoints being left or right.
}

\value{
  The function \code{make.fdt.multiple} returns a list with the slots:
  \item{table}{A \code{data.frame} storing the fdt.}
  \item{breaks}{A \code{vector} of length 4 storing \code{start}, \code{end},
    \code{h} and \code{right} of the fdt generated by this method.}
  \item{data}{A vector of the data \code{x} provided.}
}

\seealso{
 \code{\link[base]{table}} and \code{\link[base]{cut}} provided by \code{base} package.}

\author{
  Jose Claudio Faria (\email{joseclaudio.faria@gmail.com})\cr
  Enio Jelihovschi (\email{eniojelihovs@gmail.com})\cr
}

\note{
  This function is mainly for internal use in the \code{fdt} package, and may
  not remain available (unless we see a good reason).
}
