% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens.R
\name{sens_exp}
\alias{sens_exp}
\title{Adjust Exponential Distribution Parameters for Sensitivity Analyses}
\usage{
sens_exp(rate, sd_mult = 2)
}
\arguments{
\item{rate}{A non-negative numeric vector of rate.}

\item{sd_mult}{A non-negative multiplier on the standard deviation of the
distribution.}
}
\value{
A named list of the adjusted distribution's parameters.
}
\description{
Expands (\code{sd_mult > 1}) or reduces (\code{sd_mult < 1}) the standard deviation
of the exponential distribution. Due to the parameterization of this
distribution, adjusting the standard deviation necessarily changes the mean
value.
}
\examples{
sens_exp(10, 2)
sens_exp(10, 0.8)
}
\seealso{
Other sens_dist: 
\code{\link{sens_beta}()},
\code{\link{sens_gamma}()},
\code{\link{sens_gamma_pois}()},
\code{\link{sens_gamma_pois_zi}()},
\code{\link{sens_lnorm}()},
\code{\link{sens_neg_binom}()},
\code{\link{sens_norm}()},
\code{\link{sens_pois}()},
\code{\link{sens_skewnorm}()},
\code{\link{sens_student}()}
}
\concept{sens_dist}
