% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_repair.R
\name{mesh.repair}
\alias{mesh.repair}
\title{Repair of a mesh}
\usage{
mesh.repair(mesh, verbose = TRUE)
}
\arguments{
\item{mesh}{"mesh" class object.}

\item{verbose}{Boolean, by default set to \code{FALSE}. Allows you to inhibit
comments.}
}
\value{
Returns a mesh, repaired by removing degenerated triangles and filling holes.
}
\description{
The \code{mesh.repair} function repairs holes in a \code{mesh}
class object.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = c("ct", "rtstruct"), 
                             roi.name = "gizzard", dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]

# creation of the gizzard mesh
bin <- bin.from.roi (CT, struct = S, roi.name = "gizzard")
mesh.gizzard <- mesh.from.bin (bin, alias = "gizzard", verbose = FALSE)

repair.mesh.gizzard <- mesh.repair (mesh.gizzard, verbose = FALSE)
str (mesh.gizzard)
str (repair.mesh.gizzard)
}
