% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_roi_connection.R
\name{get.roi.connection}
\alias{get.roi.connection}
\title{List of inter-connections between RoI}
\usage{
get.roi.connection(vol)
}
\arguments{
\item{vol}{"volume" class object of "cluster" modality, created by
\link[espadon]{struct.clustering}}
}
\value{
Returns the list of regions of interest (RoI), where each item in the
list gives the inter-connections with other RoI.
}
\description{
The \code{get.roi.connection} function describes the interconnections
between Regions of Interest (RoI), from an imaging volume of "cluster" modality,
created by struct.clustering.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 5
patient <- toy.load.patient (modality = c ("mr", "rtstruct"),  
                             dxyz = rep (step, 3))
MR <- patient$mr[[1]]
S <- patient$rtstruct[[1]]
cluster.vol <- struct.clustering (MR, S, T.MAT = patient$T.MAT, verbose = FALSE)

get.roi.connection (cluster.vol)

}
\seealso{
\link[espadon]{struct.clustering}
}
