% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_DVH_pc.R
\name{display.DVH.pc}
\alias{display.DVH.pc}
\title{Display of a cumulative DVH in percent of total volume}
\usage{
display.DVH.pc(
  dvh,
  add = FALSE,
  xgrid = TRUE,
  ygrid = TRUE,
  MC.plot = FALSE,
  MC.col = grey.colors(4, rev = TRUE),
  ...
)
}
\arguments{
\item{dvh}{"dvh" class object. See \link[espadon]{espadon.class} for class definitions.}

\item{add}{Boolean indicating whether to display the background image.}

\item{xgrid}{Boolean indicating the display of the x grid.}

\item{ygrid}{Boolean indicating the display of the y grid.}

\item{MC.plot}{Boolean. If \code{MC.plot = TRUE}, then \code{display.DVH.pc}
displays, if they exist, the quantile zones (Prob = {0, .025, .25, .5, .75, .975, 1})
of MC DVH variations.}

\item{MC.col}{Character string, a valid palette with 4 colours corresponding
to 100\%, 95\%, 50\% and median of MC data.}

\item{...}{Arguments xlab, ylab, xlim, ylim, main, type, col, lwd, lty and log
managed by the \link[base]{plot} function.}
}
\value{
Returns a plot in percent of total volume of the cumulative histogram
included in \code{dvh}, with its median, and the quantile areas (0\%-100\%),
(2.5\%-97.5\%) and (25\%-75\%) of the \code{dvh$pcv} variations, if they exist.
}
\description{
The \code{display.DVH.pc} function displays the Dose Volume
Histogram of "dvh" class object. Y-units are percents of total volume.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for 
# better result)
step <- 5
patient <- toy.load.patient (modality = c("rtdose", "rtstruct"), 
                             roi.name = "gizzard", dxyz = rep (step, 3), 
                             beam.nb = 3)

# Calculation of the histogram
H <- histo.from.roi (patient$rtdose[[1]], patient$rtstruct[[1]], 
                     roi.name = "gizzard", 
                     breaks = seq (0, 60, by = 1))

# DVH
DVH <- histo.DVH (H)
display.DVH.pc (DVH)
}
\seealso{
\link[espadon]{display.DVH}
}
