% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicom_tag_parser.R
\name{dicom.tag.parser}
\alias{dicom.tag.parser}
\title{DICOM TAG parser}
\usage{
dicom.tag.parser(start, stop, VR, endian, dicom.raw.data, try.parse = FALSE)
}
\arguments{
\item{start}{Positive integer. Index of the first raw data to parse in the
\code{dicom.raw.data}.}

\item{stop}{Positive integer. Index of the last raw data to parse in the
\code{dicom.raw.data}.}

\item{VR}{Character string, representing the value representation of DICOM
data. See DICOM standard.}

\item{endian}{Character string, equal to "little" or "big".}

\item{dicom.raw.data}{Raw vector, representing the binary extraction of the
DICOM file.}

\item{try.parse}{Boolean. If \code{TRUE}, the value, with an undocumented VR,
is considered, as far as possible, as a string.}
}
\value{
Returns the \code{dicom.raw.data} content between the addresses
\code{start} and \code{stop}. Depending on the representation of the value
(\code{VR}), it can be a character string or a numerical vector.
}
\description{
the \code{dicom.tag.parser} function decodes the content between
two DICOM raw data addresses.
}
\examples{
# creation of the toy.dicom.raw () addresses dataframe:
df <- dicom.browser (toy.dicom.raw ())

# search for modality of toy.dicom.raw ()
idx <- grep ("^[(]0008,0060[)]$", df$tag)
modality  <- dicom.tag.parser (df$start[idx], df$stop[idx], df$VR[idx], 
                               df$endian[idx], toy.dicom.raw ())
modality
}
