% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_Rdcm_raw_data.R
\name{load.Rdcm.raw.data}
\alias{load.Rdcm.raw.data}
\title{Loading a *.Rdcm file}
\usage{
load.Rdcm.raw.data(Rdcm.filename, address = TRUE, data = TRUE)
}
\arguments{
\item{Rdcm.filename}{Character string, representing the full name of a *.Rdcm
file created by \link[espadon]{dicom.to.Rdcm.converter}.}

\item{address}{boolean. If TRUE, a dataframe with the address of the tags in
the raw DICOM data is returned.}

\item{data}{boolean. If TRUE, the DICOM information are returned as an R list.}
}
\value{
Returns a list containing the information, converted by \pkg{espadon}, of a
DICOM object..
}
\description{
the \code{load.Rdcm.raw.data} function loads the content of a *.Rdcm file.
}
\examples{
# For testing, save first toy.dicom.raw () raw data to a temporary file, and
# convert it in Rdcm fie
pat.src.dir <- file.path (tempdir(), "PM_dcm") 
dir.create (pat.src.dir, recursive = TRUE) 
dcm.filename <- tempfile (pattern = "PM_rtplan", tmpdir = pat.src.dir,
                          fileext = ".dcm")
zz <- file (dcm.filename, "wb")
writeBin (toy.dicom.raw (), zz, size = 1)
close (zz)
pat.dir <- file.path (tempdir(), "PM_Rdcm")
dicom.to.Rdcm.converter (pat.src.dir, pat.dir, update = TRUE)
lf <- list.files (pat.dir, pattern = "[.]Rdcm$", full.names = TRUE)
lf

# Inspect Rdcm raw data
L <- load.Rdcm.raw.data (lf)
str (L, max.level =3)
}
\seealso{
\link[espadon]{dicom.to.Rdcm.converter}, \link[espadon]{load.obj.from.Rdcm}.
}
