% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitDateTime.R
\name{splitDateTime}
\alias{splitDateTime}
\title{splitDateTime}
\usage{
splitDateTime(refOrEsDf = NULL, refOrEs = NULL, RELEVANTINFO_ES = NULL,
  RELEVANTVN_ES = NULL, RELEVANTVN_REF = NULL, dateTimeFormat = "ymd_HMS")
}
\arguments{
\item{refOrEsDf}{a data.frame. Either the reference dataset or the event sampling raw dataset (already merged to a single dataset).}

\item{refOrEs}{a character string. Enter "REF" if the argument refOrEs is the reference dataset, enter "ES" if it is the event sampling dataset.}

\item{RELEVANTINFO_ES}{a list. This list is generated by function \code{\link{setES}}.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}

\item{RELEVANTVN_REF}{a list. This list is generated by function \code{\link{setREF}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}

\item{dateTimeFormat}{a character string. Choose the current date-time format, "ymd_HMS" (default), "mdy_HMS", or "dmy_HMS".}
}
\value{
The dataset that was passed as first argument with four additional columns, i.e. the separate date and time objects of the combined date-time objects of both ESM start and ESM end. See \strong{Details} for more information.
}
\description{
splitDateTime splits a date-time object into its components date and time.
}
\details{
Splitting up a date-time object means to separate it into a data-object, e.g. 2007-10-03 and a time-object, e.g. 12:00:00.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute splitDateTime. Start ------------
# keyLsNew is delivered with the package. Remove the separate date
# and time for both start and end in each of the ESM datasets.
keyLsNewDT <- sapply(keyLsNew, function(x) {
     x <- x[,-match(c("start_date", "start_time",
"end_date", "end_time"), names(x))]
     return(x) } )
relEs <- relevantESVN(svyName="survey_name", IMEI="IMEI",
START_DATETIME="ES_START_DATETIME", END_DATETIME="ES_END_DATETIME")
imeiNumbers <- as.character(referenceDf$imei)
surveyNames <- c("morningTestGroup", "dayTestGroup", "eveningTestGroup",
"morningControlGroup", "dayControlGroup", "eveningControlGroup")
RELEVANT_ES <- setES(4, imeiNumbers, surveyNames, relEs)
RELEVANTINFO_ES <- RELEVANT_ES[["RELEVANTINFO_ES"]]
RELEVANTVN_ES <- RELEVANT_ES[["RELEVANTVN_ES"]]
# referenceDfNew is delivered with the package. Remove the separate
# date and time for both start and end.
referenceDfNewDT <- referenceDfNew[,-match(c("start_date", "start_time",
"end_date", "end_time"), names(referenceDfNew))]
relRef <- relevantREFVN(ID="id", IMEI="imei", ST="st",
START_DATETIME="REF_START_DATETIME", END_DATETIME="REF_END_DATETIME")
RELEVANTVN_REF <- setREF(4, relRef)
# Prerequisites in order to execute splitDateTime. End --------------
# ------------------------------------------------------
# Run function 7 of 28; see esmprep functions' hierarchy.
# ------------------------------------------------------
# Applying function to reference dataset (7a of 28)
referenceDfList <- splitDateTime(referenceDfNewDT, "REF", RELEVANTINFO_ES, RELEVANTVN_ES,
RELEVANTVN_REF)

# Extract reference dataset from output
referenceDfNew <- referenceDfList[["refOrEsDf"]]
names(referenceDfNew)

# Extract extended list of relevant variables names of reference dataset
RELEVANTVN_REF <- referenceDfList[["extendedVNList"]]

# Applying function to raw ESM dataset(s) (7b of 28)
# keyLs is the result of function 'genKey'.
keyList <- splitDateTime(keyLsNewDT, "ES", RELEVANTINFO_ES, RELEVANTVN_ES,
RELEVANTVN_REF)

# Extract list of raw ESM datasets from output
keyLsNew <- keyList[["refOrEsDf"]]

# Extract extended list of relevant variables names of raw ESM datasets
RELEVANTVN_ES <- keyList[["extendedVNList"]]
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 26 of 28).\cr \code{splitDateTime} is the reverse function of \code{\link{genDateTime}}.
}
