% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_signal.R
\name{plot_signal}
\alias{plot_signal}
\title{Plot a seismic signal}
\usage{
plot_signal(data, time, n = 10000, ...)
}
\arguments{
\item{data}{\code{eseis} object or \code{numeric} vector, data set to 
be plotted.}

\item{time}{\code{POSIXct} vector, corresponding time vector.}

\item{n}{\code{Numeric} value, number of values to which the dataset 
is reduced. Default is \code{10000}.}

\item{\dots}{Further arguments passed to the plot function.}
}
\value{
A line plot of a seismic wave form.
}
\description{
This function plots a line graph of a seismic signal. To avoid long plot 
preparation times the signal is reduced to a given number of points.
}
\details{
The \code{format} argument is based on hints provided by Sebastian 
Kreutzer and Christoph Burow. It allows plotting time axis units in 
user defined formats. The time format must be provided as character string 
using the POSIX standard (see documentation of \code{strptime} for a list 
of available keywords), e.g., "%H:%M:%S" (hour:minute:second),
"%Y-%m-%d" (year-month-day).
}
\examples{

## load example data set
data(rockfall)

## plot data set straightforward
plot_signal(data = rockfall_eseis)

## plot data set with lower resolution
plot_signal(data = rockfall_eseis, n = 100)

}
\author{
Michael Dietze
}
\keyword{eseis}
