% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolat.R
\name{evolat}
\alias{evolat}
\title{Electoral volatility calculation}
\usage{
evolat(esapsObject, method, threshold = 2, summary = FALSE, digits = 2)
}
\arguments{
\item{esapsObject}{An \code{esaps} class object. Function: \code{\link{esaps_object}}.}

\item{method}{Method to calculate electoral volatility: \code{"Pedersen"},
\code{"Powell and Tucker"} or \code{"Torcal and Lago"}.}

\item{threshold}{Minimum threshold for 'Type A' electoral volatility calculation
(Powell and Tucker, 2014). By default is 2\%.}

\item{summary}{Summary of data by country, by default it is \code{FALSE}.}

\item{digits}{integer indicating the number of decimal places to be used.}
}
\description{
Electoral volatility calculation:
    \href{http://bit.ly/2p4cyZQ}{Pedersen (1979)},
    \href{http://bit.ly/2FpoeBm}{Powell and Tucker (2014)} and
    \href{http://bit.ly/2FD83zE}{Torcal and Lago (2015)}.
}
\examples{
votes <- list(data.frame(country = rep("ARG", 3),
                         year = c(1995, 2000, 2005),
                         party_A = c(40,10,20),
                         party_B = c(35,20,40),
                         party_C = c(25,70,40)),
              data.frame(country = rep("URY", 4),
                         year = c(1995, 2000, 2005, 2010),
                         party_A = c(30,30,20,20),
                         party_B = c(30,50,40, 30),
                         party_C = c(30,10,30, 25),
                         party_D = c(10,10,10,25)),
              data.frame(country = rep("BRA", 2),
                         year = c(1993, 1998),
                         party_A = c(30, 55),
                         party_B = c(70, 45)))

votes <- esaps_object(dataset = votes, name.country = "country", name.year = "year")
volatility <- evolat(esapsObject = votes, method = "Pedersen", summary = TRUE)
}
