% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latch.R
\name{latch}
\alias{latch}
\alias{latch.e}
\alias{latch.w}
\alias{unlatch}
\title{Latch an Error or a Warning}
\usage{
latch.e(obj, error)

latch.w(obj, warning)

unlatch(obj)
}
\arguments{
\item{obj}{Object to latch the error or
warning onto.}

\item{error, warning}{Error or warning, the
output of \code{\link[=e]{e()}} or \code{\link[=w]{w()}}.}
}
\description{
Latch an error or a warning to an object
to indicate an issue associated with it.
These can later be checked with \code{\link[=is.e]{is.e()}}
and \code{\link[=is.w]{is.w()}}, and can also be \code{\link[=resolve]{resolve()}}.
}
\section{Functions}{

\itemize{
\item \code{latche} and \code{latchw}: latch an error or a warning.
\item \code{unlatch}: unlatch any error or warning.
}
}

\examples{
x <- 1
problematic <- latch.e(x, e("Not right"))

is.e(problematic)

do_sth_with_x <- function(x){
 resolve(x)
 x + 1
}

if(interactive()){
 do_sth_with_x(x)
 do_sth_with_x(problematic)
}

unlatch(problematic)

}
