% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{b1concurrent-ergmTerm}
\alias{b1concurrent-ergmTerm}
\alias{InitErgmTerm.b1concurrent}
\title{Concurrent node count for the first mode in a bipartite network}
\usage{
# binary: b1concurrent(by=NULL, levels=NULL)
}
\arguments{
\item{by}{optional argument specifying a vertex attribute (see Specifying
Vertex attributes and Levels (\code{?nodal_attributes}) for details).
It functions just like the \code{by} argument of the \code{b1degree} term.
Without the optional argument, this statistic is equivalent to \code{b1mindegree(2)} .}

\item{levels}{TODO (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}
}
\description{
This term adds one
network statistic to the model, equal to the number of nodes in the first
mode of the network with degree 2 or higher. The first mode of a bipartite
network object is sometimes known as the "actor" mode.
This term can only be
used with undirected bipartite networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b1concurrent", "subsection")}
}
\concept{bipartite}
\concept{categorical nodal attribute}
\concept{undirected}
