% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSEIRCONN.R
\name{ModelSEIRCONN}
\alias{ModelSEIRCONN}
\alias{epiworld_seirconn}
\title{Susceptible Exposed Infected Removed model (SEIR connected)}
\usage{
ModelSEIRCONN(
  name,
  n,
  prevalence,
  contact_rate,
  transmission_rate,
  incubation_days,
  recovery_rate
)
}
\arguments{
\item{name}{String. Name of the virus.}

\item{n}{Number of individuals in the population.}

\item{prevalence}{Initial proportion of individuals with the virus.}

\item{contact_rate}{Numeric scalar. Average number of contacts per step.}

\item{transmission_rate}{Numeric scalar between 0 and 1. Probability of
transmission.}

\item{incubation_days}{Numeric scalar greater than 0. Average number of
incubation days.}

\item{recovery_rate}{Numeric scalar between 0 and 1. Probability of recovery_rate.}
}
\value{
\itemize{
\item The \code{ModelSEIRCONN}function returns a model of class \link{epiworld_model}.
}
}
\description{
The SEIR connected model implements a model where all agents are connected.
This is equivalent to a compartmental model (\href{https://en.wikipedia.org/w/index.php?title=Compartmental_models_in_epidemiology&oldid=1155757336#The_SEIR_model}{wiki}).
}
\examples{
# An example with COVID-19
model_seirconn <- ModelSEIRCONN(
  name                = "COVID-19",
  prevalence          = 0.01,
  n                   = 10000,
  contact_rate        = 2,
  incubation_days     = 7,
  transmission_rate   = 0.5,
  recovery_rate       = 0.3
)

# Running and printing
run(model_seirconn, ndays = 100, seed = 1912)
model_seirconn

plot(model_seirconn)

# Adding the flu
flu <- virus("Flu", .9, 1 / 7, prevalence = 0.001, as_proportion = TRUE)
add_virus(model_seirconn, flu)

#' # Running and printing
run(model_seirconn, ndays = 100, seed = 1912)
model_seirconn

plot(model_seirconn)
}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelMeaslesQuarantine}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
