\name{as.week}

\alias{as.week}
%- Also NEED an '\alias' for EACH other topic documented here.

\title{Convert dates object in 'disease week' for plotting epidemic curves}

\description{
  Convert dates into "disease week" with values of 1 to 53 for plotting
  epidemic curves  
}

\usage{
as.week(x, format = "\%Y-\%m-\%d", 
        min.date, max.date, before = 7, after = 7,
        origin = as.Date("1970-01-01"), sunday = TRUE)
}
%- maybe also 'usage' for other objects documented here.

\arguments{
  \item{x}{
    character vector of dates
  }
  \item{format}{
    date format of \code{x}; default is of form "2004-08-10" 
  }
  \item{min.date}{
    [optional] minimum calendar date for plotting x-axis of an epidemic
    curve; should be of the form of "2004-08-10"; if no date is
    specified, then several days are subtracted from the minimum date in
    \code{x} as specified by the \code{before} option
  }
  \item{max.date}{
    [optional] maximum calendar date for plotting x-axis of an epidemic
    curve plot; should be f the form of "2004-08-10"; if no date is
    specified, then several days are added to the maximum date in
    \code{x} as specified by the \code{after} option
  }
  \item{before}{
    if \code{min.date} is not specified, then these number of days are
    subtracted from the minimum date in \code{x} for plotting minimum
    calendar date for epidemic curve
  }
  \item{after}{
    if \code{max.date} is not specified, then these number of days are
    added to the maximum date in \code{x} for plotting maximum calendar
    date for epidemic curve 
  }
  \item{origin}{
    allows user to specify an alternative origin for Julian dates that
    are generated by this function (default = "1970-01-01")
  }
  \item{sunday}{
    First day of the week is Sunday (default = TRUE); setting to FALSE
    makes Monday the first day of the week
  }
}

\details{
  In public health, reportable diseases are often reported by 'disease
  week' (either week of reporting or week of symptom onset). In R, weeks
  are numbered from 0 to 53 in the same year. The first day of week 1
  starts with either the first Sunday or Monday of the year. Days before
  week 1 are numbered as 0s.

  In contrast to R, the \code{as.week} function generates weeks numbered
  from 1 to 53. The week before week 1 takes on the value (52 or 53)
  from the last week of the previous year. The \code{as.week} functions
  facilitates working with multiple years and generating epidemic curves.
}

\value{
  Returns a list of the following:
  \item{$dates}{
    input dates are converted to standard calendar date format
  }
  \item{$firstday}{
    first day of the week is reported
  }
  \item{$week}{
    week of the year (1-53); note that week 52 or 53 can represent both
    last week of a year but also the first few days at the beginning of
    the year
  }
  \item{$stratum}{
    the Julian date for the mid-week day of the \code{$week} value
  }
  \item{$stratum2}{
    the Julian date for the mid-week day of the \code{$week} value
    converted to a factor with levels determined by the Julian dates
    (\code{$cstratum}) used to plot the epidemic curve
  }
  \item{$stratum3}{
    the mid-week day of the \code{$week} value converted to standard
    calendar dates
  }
  \item{$cweek}{
    the week of the year used for plotting the x-axis of an epidemic
    curve
  }
  \item{$cstratum}{
    the Julian date for the mid-week day of the \code{$cweek} value used
    for plotting the x-axis of an epidemic curve
  }
  \item{$cstratum2}{
    the standard calendar date for the mid-week day of the \code{$cweek}
    value used for plotting the x-axis of an epidemic curve
  }
  \item{$cmday}{
    the day of the mon (1-31) for the calendar dates used for plotting
    the x-axis of an epidemic curve
  }
  \item{$cmonth}{
    the months (Jan, Feb, Mar, ...) for the calendar dates used for
    plotting the x-axis of an epidemic curve
  }  
  \item{$cyear}{
    the years (e.g., 1996, 2001, ...) for the calendar dates used for
    plotting the x-axis of an epidemic curve
  }
}

\references{none}

\author{Tomas Aragon, \email{aragon@berkeley.edu},
  \url{http://www.medepi.com}} 

\note{Visit \url{http://www.epitools.net} for the latest.}

\seealso{
  epitools: \code{\link{as.month}}, \code{\link{epicurve.dates}}
  
  \code{\link[base]{as.Date}}, \code{\link[base]{strptime}},
  \code{\link[based]{DateTimeClasses}}}

\examples{
dates <- c("1/1/04", "1/2/04", "1/3/04", "1/4/04", "1/5/04",
"1/6/04", "1/7/04", "1/8/04", "1/9/04", "1/10/04", NA, "1/12/04",
"1/14/04", "3/5/04", "5/5/04", "7/6/04", "8/18/04", "12/13/05",
"1/5/05", "4/6/05", "7/23/05", "10/3/05")
aw <- as.week(dates, format = "\%m/\%d/\%y")
aw

aw2 <- as.week(dates, format = "\%m/\%d/\%y", sunday= FALSE)
aw2

aw3 <- as.week(dates, format = "\%m/\%d/\%y", min.date="2003-01-01")
aw3

}

\keyword{chron}
