% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extentToVect.r
\name{extentToVect}
\alias{extentToVect}
\title{Convert extent to a spatial polygon}
\usage{
extentToVect(x, ...)
}
\arguments{
\item{x}{A \code{sf}, \code{SpatVector}, \code{SpatRaster}, \code{sf}, \emph{or} a vector of four numeric values representing (in this order): x-coordinate of western side of the extent, x-coordinate of eastern side, y-coordinate of the southern side, and y-coordinate of the northern side. If numeric coordinates are supplied, the output will not have a CRS assigned to it unless supplied in \code{...}}

\item{...}{Arguments to supply to \code{vect}.}
}
\value{
A \code{SpatVector} (usual) or, if the input is an \code{sf} object, an \code{sf} polygon object.
}
\description{
This function returns a \code{SpatVector} or \code{sf} polygon representing an extent. The input can be a \code{SpatExtent} or \code{sf} object, or an object from which a \code{SpatExtent} (extent) can be obtained.
}
\examples{

data(mad0)
madExtent <- extentToVect(mad0)
plot(madExtent, border='blue', lty='dotted')
plot(mad0[1], add=TRUE)

}
\seealso{
\link{plotExtent}
}
