% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padronizar_logradouros.R
\name{padronizar_logradouros}
\alias{padronizar_logradouros}
\title{Padronizar logradouros}
\usage{
padronizar_logradouros(logradouros)
}
\arguments{
\item{logradouros}{Um vetor de caracteres. Os logradouros a serem
padronizados.}
}
\value{
Um vetor de caracteres com os logradouros padronizados.
}
\description{
Padroniza um vetor de caracteres representando logradouros de municípios
brasileiros. Veja a seção \emph{Detalhes} para mais informações sobre a
padronização.
}
\section{Detalhes}{

Operações realizadas durante a padronização:
\itemize{
\item remoção de espaços em branco antes e depois das strings e remoção de
espaços em excesso entre palavras;
\item conversão de caracteres para caixa alta;
\item remoção de acentos e caracteres não ASCII;
\item adição de espaços após abreviações sinalizadas por pontos;
\item expansão de abreviações frequentemente utilizadas através de diversas
\href{https://en.wikipedia.org/wiki/Regular_expression}{expressões regulares (regexes)};
\item correção de alguns pequenos erros ortográficos.
}
}

\examples{
logradouros <- c("r. gen.. glicério")
padronizar_logradouros(logradouros)

}
