% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-create_emuRdemoData.R
\name{create_emuRdemoData}
\alias{create_emuRdemoData}
\title{Create demo data for the emuR package}
\usage{
create_emuRdemoData(dir = tempdir(), precache = FALSE)
}
\arguments{
\item{dir}{directory to create demo data in (default= tempdir())}

\item{precache}{creates an on-file-system cache for the ae emuDB to allow fast loading
(see \code{load_emuDB} for details about the emuDB file cache)}
}
\description{
Create a folder within the folder specified
by the dir argument called emuR_demoData.
This folder contains the folders:
\itemize{
\item{ae_emuDB: Containing an emuDB that adheres to the new format specification 
(as expected by the \code{\link{load_emuDB}} function). See \code{vignette(emuDB)} 
for more information on this database format.}
\item{BPF_collection: Containing a BAS Partitur Format (BPF) file collection (as
expected by the \code{\link{convert_BPFCollection}} function)}
\item{legacy_ae: Containing a legacyEmuDB (as expected by the 
\code{\link{convert_legacyEmuDB}} function)}
\item{TextGrid_collection: Containing a TextGrid file collection 
(as expected from the \code{\link{convert_TextGridCollection}} function)}
}
}
\examples{
\dontrun{

# create demo data directory in directory
# provided by the tempdir function
create_emuRdemoData(dir = tempdir())
}
}
