% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.R
\name{SetGetRemoveLegalLabels}
\alias{SetGetRemoveLegalLabels}
\alias{get_legalLabels}
\alias{remove_legalLabels}
\alias{set_legalLabels}
\title{Set / Get / Remove legal labels of attributeDefinition of emuDB}
\usage{
set_legalLabels(emuDBhandle, levelName, attributeDefinitionName, legalLabels)

get_legalLabels(emuDBhandle, levelName, attributeDefinitionName)

remove_legalLabels(emuDBhandle, levelName, attributeDefinitionName)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{levelName}{name of level}

\item{attributeDefinitionName}{name of attributeDefinition (can be and often is the level name)}

\item{legalLabels}{character vector of labels}
}
\description{
Set / Get / Remove legal labels of a specific attributeDefinition of a emuDB. 
The legal labels are a character vector of strings
that specifies the labels that are legal (i.e. allowed / valid) for the given attribute. 
As the EMU-webApp won't allow the annotator to enter any labels that are not 
specified in this array, this is a simple way of assuring that a level 
has a consistent label set. For more information 
on the structural elements of an emuDB see \code{vignette(emuDB)}.
Note that defining legal labels for an attributeDefinition does not imply that the 
existing labels are checked for being 'legal' in the emuDB.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

legalPhoneticLabels = c("V", "m", "N", "s", "t", "H", "@:", "f", "r", 
                        "E", "n", "z", "S", "i:", "w", "@", "k", "I", "d", 
                        "db", "j", "u:", "dH", "l", "ai", "O", "D", "o:", "v")

# set legal labels of the 
# default "Phonetic" attributeDefinition of
# the "Phonetic" level of ae emuDB
set_legalLabels(emuDBhandle = ae, 
                levelName = "Phonetic",
                attributeDefinitionName = "Phonetic",
                legalLabels = legalPhoneticLabels)

# get legal labels of the 
# default "Phonetic" attributeDefinition of
# the "Phonetic" level of ae emuDB
get_legalLabels(emuDBhandle = ae, 
                levelName = "Phonetic", 
                attributeDefinitionName = "Phonetic")
                

# remove legal labels of the 
# default "Phonetic" attributeDefinition of
# the "Phonetic" level of ae emuDB
remove_legalLabels(emuDBhandle = ae, 
                   levelName = "Phonetic", 
                   attributeDefinitionName = "Phonetic")
                
}

}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}
\keyword{schema}

