% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_dyads.R
\name{count_dyads}
\alias{count_dyads}
\title{Count attribute combinations of dyads in ego-centered networks}
\usage{
count_dyads(
  object,
  alter_var_name,
  return_as = c("wide", "long"),
  prefix = NULL
)
}
\arguments{
\item{object}{An \code{egor} object.}

\item{alter_var_name}{\code{Character}, naming the alter variable to use as
attribute.}

\item{return_as}{\code{Character}, either "wide" (default) or "long".}

\item{prefix}{\code{Character}, added in front of variables. Only used if
\code{return_as} is "wide". If \code{NULL} (default) prefix is automatically generated.}
}
\value{
Wide or long \code{tibble}/ \code{data.frame}.
}
\description{
\code{count_dyads()} counts the attribute combinations of alter-alter ties/ dyads
in ego-centered networks. The results can be returned as a wide or long
\code{tibble}/ \code{data.frame}.
}
\examples{
data(egor32)
count_dyads(object = egor32,
            alter_var_name = "country")

# Return result as long tibble. 
count_dyads(object = egor32,
            alter_var_name = "country",
            return_as = "long")
}
