% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackedsdm_s3.R
\name{residuals.stackedsdm}
\alias{residuals.stackedsdm}
\title{Calculate residuals from a stackedsdm object}
\usage{
\method{residuals}{stackedsdm}(object, type = "dunnsmyth", seed = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{stackedsdm};}

\item{type}{Determined what type of residuals to calculate. The current options include Dunn-Smyth residuals (default; "dunnsmyth"), raw response residuals ("response") or probability integral transform residuals ("PIT");}

\item{seed}{For Dunn-Smyth and PIT residuals applied to discrete responses, random jittering is added, and the seed can be used to seed to jittering.}

\item{...}{not used}
}
\value{
A matrix of residuals
}
\description{
Calculate residuals from a stackedsdm object
}
\section{Details}{

Calculated the residuals from \code{stackedsdm} object.
}

\section{Author(s)}{

Francis K.C. Hui <francis.hui@anu.edu.au>.
}

\examples{
X <- as.data.frame(spider$x)
abund <- spider$abund

# Example 1: Simple example
myfamily <- "negative.binomial"
# Example 1: Funkier example where Species are assumed to have different distributions
# Fit models including all covariates are linear terms, but exclude for bare sand
fit0 <- stackedsdm(abund, formula_X = ~. -bare.sand, data = X, family = myfamily, ncores=2) 
residuals(fit0)

# Example 2: Funkier example where Species are assumed to have different distributions
abund[,1:3] <- (abund[,1:3]>0)*1 # First three columns for presence absence
myfamily <- c(rep(c("binomial"), 3),
              rep(c("negative.binomial"), (ncol(abund)-3)))
fit0 <- stackedsdm(abund, formula_X = ~ bare.sand, data = X, family = myfamily, ncores=2)
residuals(fit0)
}
