% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core3D.R
\name{qProb.3d}
\alias{qProb.3d}
\title{Q probabilities for n steps}
\usage{
qProb.3d(sim, n.locs, parallel = FALSE, maxBin = 25)
}
\arguments{
\item{sim}{the result of \link[eRTG3D]{sim.uncond.3d}, or a data frame with at least
x,y,z-coordinates, the arrival azimuth and the arrival gradient.}

\item{n.locs}{number of total segments to be modeled,
the length of the desired conditional empirical random walk}

\item{parallel}{logical: run computations in parallel (n-1 cores)? Or numeric: the number of nodes (maximum: n - 1 cores)}

\item{maxBin}{numeric scalar, maximum number of bins per dimension of the tld-cube (\link[eRTG3D]{turnLiftStepHist})}
}
\value{
A list containing the Q - tldCubes for every step
}
\description{
Calculates the Q probability, representing the pull to
the target. The number of steps on which the Q prob will be
quantified is number of total segments less than one
(the last step is defined by the target itself).
}
\examples{
qProb.3d(niclas, 3)
}
