% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper3D.R
\name{get.track.densities.3d}
\alias{get.track.densities.3d}
\title{Extract tldCube and autodifferences functions from a consistent track}
\usage{
get.track.densities.3d(track, gradientDensity = TRUE,
  heightDistEllipsoid = TRUE, DEM = NULL, maxBin = 25)
}
\arguments{
\item{track}{a data.frame with 3 columns containing the x,y,z coordinates}

\item{gradientDensity}{logical: Should a distribution of the gradient angle be extracted and later used in the simulations?}

\item{heightDistEllipsoid}{logical: Should a distribution of the flight height over ellipsoid be extracted and later used in the sim.cond.3d()?}

\item{DEM}{a raster containing a digital elevation model, covering the same extent as the track}

\item{maxBin}{numeric scalar, maximum number of bins per dimension of the tld-cube (\link[eRTG3D]{turnLiftStepHist})}
}
\value{
A list containing the tldCube and the autodifferences functions (and additionally the height distribution function)
}
\description{
Get densities creates a list consisting of the 3 dimensional
probability distribution cube for turning angle, lift angle and step length (\link[eRTG3D]{turnLiftStepHist})
as well as the uni-dimensional distributions of the differences
of the turning angles, lift angles and step lengths with a lag of 1 to maintain
minimal level of autocorrelation in each of the terms.
}
\section{Note}{

The time between the acquisition of fix points  of the track must be constant,
otherwise this leads to distorted statistic distributions,
which increases the probability of dead ends. In this case please check
\link[eRTG3D]{track.split.3d} and \link[eRTG3D]{get.section.densities.3d}
}

\examples{
get.track.densities.3d(niclas, heightDist = TRUE)
}
