% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrTaste.R
\name{dynr.taste2}
\alias{dynr.taste2}
\title{Re-fit state-space model using the estimated outliers.}
\usage{
dynr.taste2(dynrModel, dynrCook, dynrTaste, delta_inn = c("t", "ind", "jnt",
  "null"), delta_add = c("t", "ind", "jnt", "null"), delta_L = NULL,
  delta_O = NULL, cook = TRUE, verbose = FALSE,
  newOutfile = "new_taste.c")
}
\arguments{
\item{dynrModel}{an object of dynrModel class.}

\item{dynrCook}{an object of dynrCook class.}

\item{dynrTaste}{an object of dynrTaste class. The default is NULL.}

\item{delta_inn}{a character string for a method detecting `inn'ovative outliers,
which must be one of ``t'' (default), ``ind'', ``jnt'' or ``null''.
According to the method,
corresponding delta estimates (magnitude of estimated outliers) 
will be included in the new dynrModel in output.
`t' represents the t statistic, `ind' represents the independent chi-square statistic,
`jnt' represents the joint chi-square statistic.
If no outliers are assumed, ``null'' can be used.}

\item{delta_add}{a character string for a method detecting `add'itive outliers,
which must be one of ``t'' (default), ``ind'', ``jnt'' or ``null''.
According to the method,
corresponding delta estimates will be included in the new dynrModel.}

\item{delta_L}{a data.frame containing user-specified latent outliers.
The delta estimates from \code{dynrTaste} will be ignored.
The number of rows should equal to the total time points, and the number of columns should equal to the number of latent variables.}

\item{delta_O}{a data.frame containing user-specified observed outliers.
The delta estimates from \code{dynrTaste}, and 
arguments of \code{delta_inn} and \code{delta_add} will be ignored.
The number of rows should equal to the total time points, and the number of columns should equal to the number of observed variables.}

\item{cook}{a logical specifying whether the newly built model
would be cooked by 'dynr.cook' function.
The default is TRUE. When 'cook=FALSE', only the newly built model will be saved for the output.}

\item{verbose}{a logical specifying the verbose argument
of the new cook object. The default is FALSE.}

\item{newOutfile}{a character string for \code{outfile}
argument of \code{dynr.model} function
to create new \code{dynrModel} object.
The default is "new_taste.c".}
}
\value{
a list with the two arguments;
a new \code{dynrModel} object the outliers are applied,
and a \code{dynrCook} object the new \code{dynrModel} object is cooked.
}
\description{
The function \code{dynr.taste2{}} update the \code{dynrModel}
object applying outliers from the \code{dynrTaste} object,
or outliers from users. The function then re-cook the model.
}
\details{
The argument \code{dynrTaste} should be the dynrTaste object
that is output of the \code{dynr.taste} function the argument \code{dynrModel} is applied.

The argument \code{dynrTaste} can be \code{NULL},
if user-specified outliers are offered by the arguments
\code{delta_L} and \code{delta_O}.
}

