% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_capture_exclusions}
\alias{p_capture_exclusions}
\title{Start capturing exclusions on a tracked dataframe.}
\usage{
p_capture_exclusions(.data, .capture = TRUE)
}
\arguments{
\item{.data}{a tracked dataframe}

\item{.capture}{Should we capture exclusions (things removed from the data
set). This is useful for debugging data issues but comes at a significant
cost. Defaults to the value of \code{getOption("dtrackr.exclusions")} or
\code{FALSE}.}
}
\value{
the .data dataframe with the exclusions flag set (or cleared if
\code{.capture=FALSE}).
}
\description{
Start capturing exclusions on a tracked dataframe.
}
\examples{
library(dplyr)
library(dtrackr)
tmp = iris \%>\% track() \%>\% capture_exclusions()
tmp \%>\% filter(Species!="versicolor") \%>\% history()
}
