% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-first.R
\name{lazy_dt}
\alias{lazy_dt}
\alias{tbl_dt}
\alias{grouped_dt}
\title{Create a "lazy" data.table for use with dplyr verbs}
\usage{
lazy_dt(x, name = NULL, immutable = TRUE, key_by = NULL)
}
\arguments{
\item{x}{A data table (or something can can be coerced to a data table).}

\item{name}{Optionally, supply a name to be used in generated expressions.
For expert use only.}

\item{immutable}{If \code{TRUE}, \code{x} is treated as immutable and will never
be modified by any code generated by dtplyr. Alternatively, you can set
\code{immutable = FALSE} to allow dtplyr to modify the input object.}

\item{key_by}{Set keys for data frame, using \code{\link[=select]{select()}} semantics (e.g.
\code{key_by = c(key1, key2)}.

This uses \code{\link[data.table:setkey]{data.table::setkey()}} to sort the table and build an index.
This will considerably improve performance for subsets, summaries, and
joins that use the keys.

See \code{vignette("datatable-keys-fast-subset")} for more details.}
}
\description{
A lazy data.table lazy captures the intent of dplyr verbs, only actually
performing computation when requested (with \code{\link[=collect]{collect()}}, \code{\link[=pull]{pull()}},
\code{\link[=as.data.frame]{as.data.frame()}}, \code{\link[data.table:as.data.table]{data.table::as.data.table()}}, or \code{\link[tibble:as_tibble]{tibble::as_tibble()}}).
This allows dtplyr to convert dplyr verbs into as few data.table expressions
as possible, which leads to a high performance translation.

See \code{vignette("translation")} for the details of the translation.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

# If you have a data.table, using it with any dplyr generic will
# automatically convert it to a lazy_dt object
dt <- data.table::data.table(x = 1:10, y = 10:1)
dt \%>\% filter(x == y)
dt \%>\% mutate(z = x + y)

# Note that dtplyr will avoid mutating the input data.table, so the
# previous translation includes an automatic copy(). You can avoid this
# with a manual call to lazy_dt()
dt \%>\%
  lazy_dt(immutable = FALSE) \%>\%
  mutate(z = x + y)

# If you have a data frame, you can use lazy_dt() to convert it to
# a data.table:
mtcars2 <- lazy_dt(mtcars)
mtcars2
mtcars2 \%>\% select(mpg:cyl)
mtcars2 \%>\% select(x = mpg, y = cyl)
mtcars2 \%>\% filter(cyl == 4) \%>\% select(mpg)
mtcars2 \%>\% select(mpg, cyl) \%>\% filter(cyl == 4)
mtcars2 \%>\% mutate(cyl2 = cyl * 2, cyl4 = cyl2 * 2)
mtcars2 \%>\% transmute(cyl2 = cyl * 2, vs2 = vs * 2)
mtcars2 \%>\% filter(cyl == 8) \%>\% mutate(cyl2 = cyl * 2)

# Learn more about translation in vignette("translation")
by_cyl <- mtcars2 \%>\% group_by(cyl)
by_cyl \%>\% summarise(mpg = mean(mpg))
by_cyl \%>\% mutate(mpg = mean(mpg))
by_cyl \%>\%
  filter(mpg < mean(mpg)) \%>\%
  summarise(hp = mean(hp))
}
