% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic6.R
\name{logistic6_fn}
\alias{logistic6_fn}
\title{6-parameter logistic function}
\usage{
logistic6_fn(x, theta)
}
\arguments{
\item{x}{numeric vector at which the logistic function is to be evaluated.}

\item{theta}{numeric vector with the six parameters in the form
\code{c(alpha, beta, eta, phi, nu, xi)}.}
}
\value{
Numeric vector of the same length of \code{x} with the values of the
logistic function.
}
\description{
Evaluate at a particular set of parameters the 6-parameter logistic function.
}
\details{
The 6-parameter logistic function \verb{f(x; theta)} is defined here as

\code{alpha + (beta - alpha) / (xi + nu * exp(-eta * (x - phi)))^(1 / nu)}

where \code{theta = c(alpha, beta, eta, phi, nu, xi)}, \code{beta > alpha}, \code{xi > 0},
and \code{nu > 0}.
}
