% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_icon.R
\name{dq_icon}
\alias{dq_icon}
\title{Creates an icon element}
\usage{
dq_icon(
  icon,
  lib = "font-awesome",
  fa_style = c("fas", "far", "fal"),
  color = "#ff8f00",
  bg_color = NULL,
  size = NULL,
  ...
)
}
\arguments{
\item{icon}{name of the icon to show}

\item{lib}{library used, needed to append the proper dependency}

\item{fa_style}{fontawesome icon style to use, one of c("fas", "far", "fal")
for "solid", "regular" or "light" (PRO only)}

\item{color}{icon color, can be any valid CSS color code}

\item{bg_color}{icon background color, can be any valid CSS color code}

\item{size}{character specifying the size of the icon, can be one of "xs",
"sm", "lg", "2x", "3x", "4x", "5x", "6x", "7x", "8x", "9x", "10x"}

\item{...}{additional attributes like style or class}
}
\value{
icon html element
}
\description{
Creates a html icon element with the specified icon name from
the given library.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
addResourcePath("images", system.file("www", "img", package = "dqshiny"))
shinyApp(
  ui = fluidPage(
    dq_icon("table", size = "4x"),
    dq_icon("check", color = "red", lib = "glyphicon", size = "2x"),
    dq_icon("phone", bg_color = "green", size = "lg"),
    dq_icon("images/logo_daqana.svg", size = "3x")
  ),
  server = function(input, output, session) {}
)

}
}
\author{
richard.kunze
}
