% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers.R
\docType{data}
\name{numb_replacements}
\alias{numb_replacements}
\title{Dictionary of English names of numbers}
\format{
An object of class \code{character} of length 49.
}
\source{
\url{https://github.com/benmarwick/words2number}
}
\usage{
numb_replacements
}
\description{
For internal use in \code{\link{words2number}}. When passed as a replacement
to a function like
\code{\link[stringr:str_replace]{str_replace_all}}, it turns the
string into an arithmetic expression that can be evaluated to give an integer
representation of the named number.
}
\details{
Lifted from Ben Marwick's \code{words2number} package and converted into
a named vector (previously a chain of \code{\link{gsub}} calls).
}
\note{
Does not yet fully support decimals, fractions or mixed fractions.
Some limited support for 'half' expressions, e.g. 'one and a half'.
}
\examples{
\dontrun{
stringr::str_replace_all('one hundred and forty-two', numb_replacements)
}

}
\keyword{datasets}
