% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-functions-misc.R
\name{match_pts_to_graph}
\alias{match_pts_to_graph}
\title{match_pts_to_graph}
\usage{
match_pts_to_graph(verts, xy)
}
\arguments{
\item{verts}{A \code{data.frame} of vertices obtained from
\code{dodgr_vertices(graph)}.}

\item{xy}{coordinates of points to be matched to the vertices}
}
\value{
A vector index into verts
}
\description{
Match spatial points to a spatial graph which contains vertex coordindates
}
\examples{
net <- weight_streetnet (hampi, wt_profile = "foot")
verts <- dodgr_vertices (net)
# Then generate some random points to match to graph
npts <- 10
xy <- data.frame (
                  x = min (verts$x) + runif (npts) * diff (range (verts$x)),
                  y = min (verts$y) + runif (npts) * diff (range (verts$y))
                  )
pts <- match_pts_to_graph (verts, xy)
pts # an index into verts
pts <- verts$id [pts]
pts # names of those vertices
}
