% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dodgr-package.r
\docType{package}
\name{dodgr}
\alias{dodgr}
\alias{dodgr-package}
\title{dodgr.}
\description{
Distances on dual-weighted directed graphs using priority-queue shortest
paths. Weighted directed graphs have weights from A to B which may differ
from those from B to A. Dual-weighted directed graphs have two sets of such
weights. A canonical example is a street network to be used for routing in
which routes are calculated by weighting distances according to the type of
way and mode of transport, yet lengths of routes must be calculated from
direct distances.
}
\section{The Main Function}{

\itemize{
\item \code{\link{dodgr_dists}}: Calculate pair-wise distances between
specified pairs of points in a graph.
}
}

\section{Functions to Obtain Graphs}{

\itemize{
\item \code{\link{dodgr_streetnet}}: Extract a street network in Simple
Features (\code{sf}) form.
\item \code{\link{weight_streetnet}}: Convert an \code{sf}-formatted street
network to a \code{dodgr} graph through applying specified weights to all
edges.
}
}

\section{Functions to Modify Graphs}{

\itemize{
\item \code{\link{dodgr_components}}: Number all graph edges according to
their presence in distinct connected components.
\item \code{\link{dodgr_contract_graph}}: Contract a graph by removing
redundant edges.
}
}

\section{Miscellaneous Functions}{

\itemize{
\item \code{\link{dodgr_sample}}: Randomly sample a graph, returning a single
connected component of a defined number of vertices.
\item \code{\link{dodgr_vertices}}: Extract all vertices of a graph.
\item \code{\link{compare_heaps}}: Compare the performance of different
priority queue heap structures for a given type of graph.
}
}

