% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.R
\name{DerivLogf}
\alias{Deriv2Logf}
\alias{DerivLogf}
\title{Build Derivative Function for Log f}
\usage{
DerivLogf(f, names, map = NULL, yMap = NULL, thetaMap = NULL)

Deriv2Logf(f, names, map = NULL, yMap = NULL, thetaMap = NULL)
}
\arguments{
\item{f}{an expression, a joint probability density.}

\item{names}{a character vector of variable names.}

\item{map}{a named list of character strings defining left assignments (\code{a="b"} => \code{a <- b}).}

\item{yMap}{like \code{map} with \code{a=b} resolving to \code{a <- y[b]}.}

\item{thetaMap}{like \code{map} with \code{a=b} resolving to \code{a <- theta[[b]]}.}
}
\value{
\code{DerivLogf} returns \code{function(y, theta, i, ...)} where \code{theta} is a list of parameters.
It evaluates to the first derivative of \code{log(f)} with respect to variable \code{i}.
Additionally the attribute \code{"d"} contains the list of sub functions.

\code{Deriv2Logf} returns \code{function(y, theta, i, j, ...)} where \code{theta} is a list of parameters.
It evaluates to the second derivative of \code{log(f)} with respect to the variables \code{i} and \code{j}.
Additionally the attribute \code{"d2"} contains the list of sub functions.
}
\description{
Builds a function that evaluates to the first/second derivative of \code{log(f)} with respect to a predefined set of variables/variable combinations.
}
\details{
While \code{numDerivLogf} relies on \pkg{numDeriv} and therefore uses finite differences to evaluate the derivatives, \code{DerivLogf} utilizes \code{Deriv} to build sub functions for each variable in \code{names}.
The same is true for \code{Deriv2Logf}.

\code{Deriv} won't recognize components or parameters accessed by \code{[}, \code{[[} or \code{$} as variables (e.g. \code{theta[["beta1"]]}).
Therefore it's necessary to specify mappings from \code{y} and \code{theta} to the variables in \code{f}.
}
\examples{
## see examples for param
## mind the gain regarding runtime compared to numDeriv
}
\seealso{
\code{\link[Deriv]{Deriv}} in package \pkg{Deriv}, \code{\link{buildf}}, \code{\link{numDerivLogf}}, \code{\link{fisherI}}
}

