% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dFunArgs.r
\name{dFunArgs}
\alias{dFunArgs}
\title{Function to assign (and evaluate) arguments with default values for an input function}
\usage{
dFunArgs(fun, action = F, verbose = T)
}
\arguments{
\item{fun}{an input function name (character string)}

\item{action}{logical to indicate whether the function will act as it
should be (with assigned values in the current environment). By
default, it sets to FALSE}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
a list containing arguments and their default values
}
\description{
\code{dFunArgs} is supposed to assign (and evaluate) arguments with
default values for an input function.
}
\note{
This function is potentially useful when debugging. Because the
developer does not have to specify default values for all arguments
except those arguments are of interest
}
\examples{
\dontrun{
fun <- "dNetPipeline"
dFunArgs(fun)
}
}
\seealso{
\code{\link{dNetPipeline}}
}

