% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{plot_qq_numeric}
\alias{plot_qq_numeric}
\alias{plot_qq_numeric.data.frame}
\alias{plot_qq_numeric.grouped_df}
\title{Plot Q-Q plot of numerical variables}
\usage{
plot_qq_numeric(.data, ...)

\method{plot_qq_numeric}{data.frame}(
  .data,
  ...,
  col_point = "steelblue",
  col_line = "black",
  title = "Q-Q plot by numerical variables",
  each = FALSE,
  typographic = TRUE
)

\method{plot_qq_numeric}{grouped_df}(
  .data,
  ...,
  col_point = "steelblue",
  col_line = "black",
  title = "Q-Q plot by numerical variables",
  each = FALSE,
  typographic = TRUE
)
}
\arguments{
\item{.data}{data.frame or a \code{\link{tbl_df}} or a \code{\link{grouped_df}}.}

\item{\dots}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_qq_numeric() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context where
column names represent column positions.
They support unquoting and splicing.}

\item{col_point}{character. a color of points in Q-Q plot.}

\item{col_line}{character. a color of line in Q-Q plot.}

\item{title}{character. a main title for the plot.}

\item{each}{logical. Specifies whether to draw multiple plots on one screen. 
The default is FALSE, which draws multiple plots on one screen.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}
}
\description{
The plot_qq_numeric() to visualizes the Q-Q plot of numeric data or 
relationship to specific categorical data.
}
\details{
The The Q-Q plot helps determine whether the distribution of a numeric variable 
is normally distributed. plot_qq_numeric() shows Q-Q plots of several numeric variables 
on one screen. This function can also display a Q-Q plot for each level of a specific 
categorical variable.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Visualization of all numerical variables
# plot_qq_numeric(carseats)

# Select the variable to diagnose
# plot_qq_numeric(carseats, "Sales", "Income")
plot_qq_numeric(carseats, -Sales, -Income)

# Not allow the typographic elements
# plot_qq_numeric(carseats, "Sales", typographic = FALSE)

# Using pipes ---------------------------------
library(dplyr)

# Plot of all numerical variables
# carseats \%>\%
#   plot_qq_numeric()
  
# Using groupd_df  ------------------------------
carseats \%>\% 
  group_by(ShelveLoc) \%>\% 
  plot_qq_numeric()
  
#carseats \%>\% 
#   group_by(ShelveLoc) \%>\% 
#   plot_qq_numeric(each = TRUE)  
  
}
