% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{plot.univar_category}
\alias{plot.univar_category}
\title{Visualize Information for an "univar_category" Object}
\usage{
\method{plot}{univar_category}(x, na.rm = TRUE, prompt = FALSE, typographic = TRUE, ...)
}
\arguments{
\item{x}{an object of class "univar_category", usually, a result of a call to univar_category().}

\item{na.rm}{logical. Specifies whether to include NA when plotting bar plot. 
The default is FALSE, so plot NA.}

\item{prompt}{logical. The default value is FALSE. If there are multiple visualizations to be output, 
if this argument value is TRUE, a prompt is output each time.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).
However, it does not support all parameters.}
}
\description{
Visualize mosaics plot by attribute of univar_category class.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

library(dplyr)

# Calculates the all categorical variables
all_var <- univar_category(carseats)

# Print univar_category class object
all_var

# Calculates the only Urban variable
urban <- univar_category(carseats, Urban)
  
# Print univar_category class object
urban

# plot all variables
plot(all_var)

# plot urban
plot(urban)

# plot all variables by na.rm = FALSE
plot(all_var, na.rm = FALSE)
 
# plot all variables by prompt
# plot(all_var, prompt = TRUE)

# not allow the typographic elements
plot(all_var, typographic = FALSE)

}
\seealso{
\code{\link{univar_category}}, \code{\link{print.univar_category}}, \code{\link{summary.univar_category}}.
}
