% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_contents.R
\name{gradient_value}
\alias{gradient_value}
\alias{use_glm_gradient_value}
\title{Estimate the update gradient value}
\usage{
gradient_value(
  beta = NULL,
  data,
  formula,
  family = binomial(),
  iteration_number = 0,
  shuffle_rows = TRUE,
  link = NULL
)

use_glm_gradient_value(
  beta = NULL,
  data,
  formula,
  family = binomial(),
  iteration_number = 0,
  shuffle_rows = TRUE
)
}
\arguments{
\item{beta}{current beta value, leave \code{NULL} to initialize}

\item{data}{dataset to get gradient value from}

\item{formula}{model formula to fit, with tilde syntax}

\item{family}{generalized linear model family, see \code{\link{family}}}

\item{iteration_number}{number of fitting iteration, used for tracking}

\item{shuffle_rows}{should the rows of the dataset be permuted, so
as to decrease privacy concerns}

\item{link}{link function to use with family}
}
\value{
A list of estimated values, including the gradient,
sample size, iteration number, covariance matrix (\code{A_mat}),
number of samples with non-zero weights, the sum of the dispersion
values (for overdispersion estimates), and a vector of values
for combining to create the population gradient (\code{u}), with length
of the number of beta values
}
\description{
Estimate the update gradient value
}
\examples{
data = data.frame(y = c(0, 0, 1),
pois_y = c(4, 1, 0),
x2 = c(-2.19021287072066,
       -0.344307138450805, 3.47215796952745),
x1 = c(-0.263859503846267,
       -0.985160029707486, 0.227262373184513))
gradient_value(data = data, formula = y ~ x1 + x2,
family = "binomial")
gradient_value(data = data, formula = pois_y ~ x1 + x2,
family = "poisson")
data = data.frame(y = c(0, 0, 1),
pois_y = c(4, 1, 0),
x2 = c(-2.19021287072066,
       -0.344307138450805, 3.47215796952745),
x1 = c(-0.263859503846267,
       -0.985160029707486, 0.227262373184513))
use_glm_gradient_value(data = data, formula = y ~ x1 + x2,
family = binomial(link = "probit"))
}
