% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_contents.R
\name{estimate_new_beta}
\alias{estimate_new_beta}
\alias{compute_model}
\alias{model_trace}
\title{Estimate the updated beta value}
\usage{
estimate_new_beta(
  model_name,
  synced_folder,
  all_site_names = NULL,
  verbose = TRUE
)

compute_model(model_name, synced_folder, all_site_names = NULL, wait_time = 5)

model_trace(model_name, synced_folder)
}
\arguments{
\item{model_name}{name of your model}

\item{synced_folder}{synced folder to do computation}

\item{all_site_names}{all the site names used to fit this model}

\item{verbose}{print diagnostic messages}

\item{wait_time}{Time, in seconds, to wait until to try to
get new estimate}
}
\value{
A file name of the estimated values necessary for
the final estimates
}
\description{
Estimate the updated beta value
}
\examples{
data = data.frame(y = c(0, 0, 1),
                  pois_y = c(4, 1, 0),
                  x2 = c(-2.19021287072066,
                         -0.344307138450805, 3.47215796952745),
                  x1 = c(-0.263859503846267,
                         -0.985160029707486, 0.227262373184513))
synced_folder = tempfile()
dir.create(synced_folder)
model_name = "logistic_example"
form_file = setup_model(model_name = model_name,
                        synced_folder = synced_folder,
                        formula =  y ~ x1 + x2, family =  binomial(),
                        tolerance = 5)
outfile = estimate_site_gradient(
  model_name = model_name, synced_folder = synced_folder,
  all_site_names = "site1",
  data = data)
estimate_new_beta(model_name, synced_folder,
all_site_names = "site1")
master_beta_file(model_name, synced_folder)
outfile = estimate_site_gradient(
  model_name = model_name, synced_folder = synced_folder,
  all_site_names = "site1",
  data = data)

estimate_new_beta(model_name, synced_folder,
all_site_names = "site1")
master_beta_file(model_name, synced_folder)
}
