% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareSequences.R
\name{prepareSequences}
\alias{prepareSequences}
\title{Prepare sequences for a comparison analysis.}
\usage{
prepareSequences(
  sequence.A = NULL,
  sequence.A.name = "A",
  sequence.B = NULL,
  sequence.B.name = "B",
  merge.mode = "complete",
  sequences = NULL,
  grouping.column = NULL,
  time.column = NULL,
  exclude.columns = NULL,
  if.empty.cases = "zero",
  transformation = "none",
  paired.samples = FALSE,
  same.time = FALSE
  )
}
\arguments{
\item{sequence.A}{dataframe containing a multivariate time-series.}

\item{sequence.A.name}{character string with the name of \code{sequence.A}. Will be used as identificator in the \code{id} column of the output dataframe.}

\item{sequence.B}{dataframe containing a multivariate time-series. Must have overlapping columns with \code{sequence.A} with same column names and units.}

\item{sequence.B.name}{character string with the name of \code{sequence.B}. Will be used as identificator in the \code{id} column of the output dataframe.}

\item{merge.mode}{character string, one of: "overlap", "complete" (default option). If "overlap", \code{sequence.A} and \code{sequence.B} are merged by their common columns, and non-common columns are dropped If "complete", columns absent in one dataset but present in the other are added, with values equal to 0. This argument is ignored if \code{sequences} is provided instead of \code{sequence.A} and \code{sequence.B}.}

\item{sequences}{dataframe with multiple sequences identified by a grouping column.}

\item{grouping.column}{character string, name of the column in \code{sequences} to be used to identify separates sequences within the file. If two sequences are provided through the arguments \code{sequence.A} and \code{sequence.B}, this argument defines the name of the grouping column in the output dataframe. If two or several sequences are provided as a single dataframe through the argument \code{sequences}, then \code{grouping.column} must be a column in this dataset.}

\item{time.column}{character string, name of the column with time/depth/rank data. If \code{sequence.A} and \code{sequence.B} are provided, \code{time.column} must have the same name and units in both dataframes.}

\item{exclude.columns}{character string or character vector with column names in \code{sequences}, or \code{squence.A} and \code{sequence.B}, to be excluded from the transformation.}

\item{if.empty.cases}{character string with two possible values: "omit", or "zero". If "zero" (default), \code{NA} values are replaced by zeroes. If "omit", rows with \code{NA} data are removed.}

\item{transformation}{character string. Defines what data transformation is to be applied to the sequences. One of: "none" (default), "percentage", "proportion", "hellinger", and "scale" (the latter centers and scales the data using the \code{\link[base]{scale}} function).}

\item{paired.samples}{boolean. If \code{TRUE}, the function will test if the datasets have paired samples. This means that each dataset must have the same number of rows/samples, and that, if available, the \code{time.column} must have the same values in every dataset. This is only mandatory when using the functions \code{\link{distancePairedSamples}} or \code{\link{workflowPsi}} with \code{paired.samples = TRUE} after preparing the sequences. The default setting is \code{FALSE}.}

\item{same.time}{boolean. If \code{TRUE}, samples in the sequences to compare will be tested to check if they have the same time/age/depth according to \code{time.column}. This argument is only useful when the user needs to compare two sequences taken at different sites but same time frames.}
}
\value{
A dataframe with the multivariate time series. If \code{squence.A} and \code{sequence.B} are provided, the column identifying the sequences is named "id". If \code{sequences} is provided, the time-series are identified by \code{grouping.column}.
}
\description{
This function prepares two or more multivariate time-series that are to be compared. It can work on two different scenarios:
\itemize{
\item \emph{Two dataframes}: The user provides two separated dataframes, each containing a multivariate time series. These time-series can be regular or irregular, aligned or unaligned, but must have at least a few columns with the same names (pay attention to differences in case between column names representing the same entity) and units. This mode uses exclusively the following arguments: \code{sequence.A}, \code{sequence.A.name} (optional), \code{sequence.B}, \code{sequence.B.name} (optional), and \code{merge.model}.
\item \emph{One long dataframe}: The user provides a single dataframe, through the \code{sequences} argument, with two or more multivariate time-series identified by a \code{grouping.column}.
}
}
\examples{

#two sequences as inputs
data(sequenceA)
data(sequenceB)

AB.sequences <- prepareSequences(
 sequence.A = sequenceA,
 sequence.A.name = "A",
 sequence.B = sequenceB,
 sequence.B.name = "B",
 merge.mode = "complete",
 if.empty.cases = "zero",
 transformation = "hellinger"
 )


#several sequences in a single dataframe
data(sequencesMIS)
MIS.sequences <- prepareSequences(
 sequences = sequencesMIS,
 grouping.column = "MIS",
 if.empty.cases = "zero",
 transformation = "hellinger"
 )

}
\author{
Blas Benito <blasbenito@gmail.com>
}
