% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{graphic-devices}
\alias{graphic-devices}
\alias{dev_create}
\alias{get_dev_attr}
\title{Create a group of named graphic devices}
\usage{
dev_create(..., env = parent.frame(), attributes = list())

get_dev_attr(which, dev = grDevices::dev.cur(), ifnotfound = NULL)
}
\arguments{
\item{...}{named expressions to launch devices}

\item{env}{environment to evaluate expressions}

\item{attributes}{named list; names correspond to device names and values
are attributes to set to the devices}

\item{which}{which attribute to obtain}

\item{dev}{which device to search for attributes}

\item{ifnotfound}{value to return if attribute is not found}
}
\value{
A list of functions to query, control, and switch between devices
}
\description{
Create a group of named graphic devices
}
\examples{
\dontrun{ ## Unix-specific example

# Create multiple named devices, setting attributes to the second graph
devs <- dev_create(
  line = X11(), points = x11(),
  attributes = list(points = list(pch = 16))
)

# switch to device named "points"

devs$dev_which('points')

# Plot points, with pch given as preset
plot(1:10, pch = get_dev_attr(which = 'pch', ifnotfound = 1))

# switch to "line" device
devs$dev_switch('line')
plot(1:100, type='l')

# Create another group with conflict name
dev_another <- dev_create(line = X11())

# Query device name with 'line'
dev_another$dev_which('line')  # 4
devs$dev_which('line')  # 2, doesn't conflict with the new groups

dev.list()
# close one or more device
dev_another$dev_off('line')
dev.list()

# close all devices
devs$dev_off()
dev.list()

}
}
