% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials.R
\name{get_credential}
\alias{get_credential}
\title{Generate a random password}
\usage{
get_credential(
  master_password,
  method = c("get_or_create", "replace", "query"),
  service = NULL,
  special_chr = "~`! @#$\%^&*()_-+={[}]|:;'<,>.?/",
  tokenfile = NULL,
  verbose = FALSE
)
}
\arguments{
\item{master_password}{a master password that only you know, should have
at least 8 characters}

\item{method}{whether to query token map, or to create the password,
choices are \code{'get_or_create'} (default), \code{'replace'},
\code{'query'}; see 'Details'}

\item{service}{service name, must only contains letters, digits, equal sign,
underscore, comma, dot, dash}

\item{special_chr}{special characters allowed in the password}

\item{tokenfile}{a file containing all the tokens. Warning: if you lose the
token book, it is hard (not impossible, but impractical) to restore
the passwords}

\item{verbose}{whether to print out service names; default is false}
}
\value{
If method is \code{'query'}, returns token map; otherwise returns
the password itself
}
\description{
Please note that this function is not meant to be used in
production. It is not meant to be used for highly secured
cryptographic purposes.
}
\details{
Please note that this function is not meant to be used in
production or anything that requires high security level. This is most
likely for my personal use since I am tired of
storing the passwords on the cloud or having to buy the services.

The encryption adopts \code{'sha256'} algorithm provided by
\code{\link[digest]{digest}} function. To restore a password,
you will need twp components: \code{master_password}, a token book (
\code{tokenfile}). If any of them is missing, then the password is lost.
Please store the token book properly (for example, in 'Dropbox' vault).

The token book could be shared. Anyone who do not have master password will
be unlikely to restore the service password. Do not share the master password
with anyone other than yourself.

By default, \code{method='get_or_create'} will try to retrieve existing
tokens to generate password. If the token is missing, then a new token
will be generated. The \code{method='replace'} will ignore existing tokens
and directly create a new one.
}
\examples{

tokenfile <- tempfile()

# ---------- Create a password and store the tokens to token book ------
pass1 <- get_credential(
  master_password = "my password",
  service = "google.com:my_username",
  special_chr = "@#$\%^&*",
  tokenfile = tokenfile
)
print(pass1)

# ---------- Query existing tokens ------
token_params <- get_credential(
  method = "query",
  tokenfile = tokenfile,
  verbose = TRUE
)

print(token_params)

# ---------- retrieve stored password ----------
pass2 <- get_credential(
  master_password = "my password",
  service = "google.com",
  tokenfile = tokenfile
)
identical(pass1, pass2)

# Using wrong master password
pass3 <- get_credential(
  master_password = "wrong password",
  service = "google.com",
  tokenfile = tokenfile
)
identical(pass1, pass3)

# ---------- Replace token ----------
# Existing token will be replaced with a new token
pass4 <- get_credential(
  master_password = "my password",
  method = "replace",
  service = "google.com",
  special_chr = "@#$\%^&*",
  tokenfile = tokenfile
)
print(pass4)
identical(pass1, pass4)

}
\seealso{
\code{\link[digest]{digest}}
}
